/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import com.ibm.ras.RASTraceFormatter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;

public class TraceFormatter
extends RASTraceFormatter {
    String myhome = "<unknown>";

    public TraceFormatter() {
        this.setSeparator(":");
        this.setDateFormat(new SimpleDateFormat("yyyy.MM.dd"));
        this.setTimeFormat(new SimpleDateFormat("HH:mm:ss.SSS z"));
        this.getDate(0L);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.myhome = inetAddress.getHostAddress();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public String format(RASIEvent rASIEvent) {
        RASTraceEvent rASTraceEvent = (RASTraceEvent)rASIEvent;
        StringBuffer stringBuffer = new StringBuffer(256);
        rASIEvent.getParameters();
        stringBuffer.append(this.myhome).append('/');
        String string = (String)rASIEvent.getAttribute("sender");
        if (string == null) {
            stringBuffer.append("server").append(" - ");
        } else {
            stringBuffer.append(string).append(" - ");
        }
        long l = rASTraceEvent.getTimeStamp();
        stringBuffer.append(this.getDate(l)).append(' ');
        stringBuffer.append(this.getTime(l)).append(' ');
        stringBuffer.append(Thread.currentThread().getThreadGroup().getName()).append(' ');
        stringBuffer.append("<T> ");
        String string2 = (String)rASTraceEvent.getAttribute("className");
        String string3 = (String)rASTraceEvent.getAttribute("methodName");
        stringBuffer.append(string2).append("::").append(string3).append("()");
        stringBuffer.append(" - ").append(rASTraceEvent.getText());
        return stringBuffer.toString();
    }
}

